#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebasePurchase.h"

class FGamebaseBridgePurchase : public IGamebasePurchase, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgePurchase(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgePurchase() override = default;

    virtual void RequestPurchase(const int64 ItemSeq, const FGamebasePurchasableReceiptDelegate& Callback) override;
    virtual void RequestPurchase(const FString& GamebaseProductId, const FGamebasePurchasableReceiptDelegate& Callback) override;
    virtual void RequestPurchase(const FString& GamebaseProductId, const FString& Payload, const FGamebasePurchasableReceiptDelegate& Callback) override;
    
    virtual void RequestItemListOfNotConsumed(const FGamebasePurchasableReceiptListDelegate& Callback) override;
    virtual void RequestItemListOfNotConsumed(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback) override;
    
    virtual void RequestItemListPurchasable(const FGamebasePurchasableItemListDelegate& Callback) override;
    virtual void RequestItemListAtIAPConsole(const FGamebasePurchasableItemListDelegate& Callback) override;
    
    virtual void RequestActivatedPurchases(const FGamebasePurchasableReceiptListDelegate& Callback) override;
    virtual void RequestActivatedPurchases(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback) override;

    virtual void RequestSubscriptionsStatus(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableSubscriptionStatusDelegate& Callback) override;
    
    virtual void SetPromotionIAPHandler(const FGamebasePurchasableReceiptDelegate& Callback) override;
};
