#include "GamebaseBridgePurchase.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName RequestPurchaseSeq(TEXT("gamebase://requestPurchaseSeq"));
    const FName RequestPurchaseProductId(TEXT("gamebase://requestPurchaseProductId"));
    const FName RequestPurchaseProductIdWithPayload(TEXT("gamebase://requestPurchaseProductIdWithPayload"));
    const FName RequestItemListOfNotConsumed(TEXT("gamebase://requestItemListOfNotConsumed"));
    const FName RequestItemListPurchasable(TEXT("gamebase://requestItemListPurchasable"));
    const FName RequestItemListAtIAPConsole(TEXT("gamebase://requestItemListAtIAPConsole"));
    const FName SetPromotionIAPHandler(TEXT("gamebase://setPromotionIAPHandler"));
    const FName RequestActivatedPurchases(TEXT("gamebase://requestActivatedPurchases"));
}

FGamebaseBridgePurchase::FGamebaseBridgePurchase(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgePurchase::RequestPurchase(const int64 ItemSeq, const FGamebasePurchasableReceiptDelegate& Callback)
{
    FPurchaseItemSeq PurchaseItemSeq;
    PurchaseItemSeq.ItemSeq = ItemSeq;
    
    FGamebaseCommunicatorSendData Data { GamebaseScheme::RequestPurchaseSeq };
    Data.JsonData = PurchaseItemSeq.ToJson(false);

    Communicator->GetAsync(Data, Callback);
}

void FGamebaseBridgePurchase::RequestPurchase(const FString& GamebaseProductId, const FGamebasePurchasableReceiptDelegate& Callback)
{
    FPurchaseProductId PurchaseProductId;
    PurchaseProductId.GamebaseProductId = GamebaseProductId;
    
    FGamebaseCommunicatorSendData Data { GamebaseScheme::RequestPurchaseProductId };
    Data.JsonData = PurchaseProductId.ToJson(false);

    Communicator->GetAsync(Data, Callback);
}

void FGamebaseBridgePurchase::RequestPurchase(const FString& GamebaseProductId, const FString& Payload, const FGamebasePurchasableReceiptDelegate& Callback)
{
    FPurchaseProductId PurchaseProductId;
    PurchaseProductId.GamebaseProductId = GamebaseProductId;
    PurchaseProductId.Payload = Payload;
    
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::RequestPurchaseProductIdWithPayload };
    SendData.JsonData = PurchaseProductId.ToJson(false);

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::RequestItemListOfNotConsumed(const FGamebasePurchasableReceiptListDelegate& Callback)
{
    const FGamebasePurchasableConfiguration Configuration;
    RequestItemListOfNotConsumed(Configuration, Callback);
}

void FGamebaseBridgePurchase::RequestItemListOfNotConsumed(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestItemListOfNotConsumed };
    SendData.JsonData = Configuration.ToJson();
    SendData.ExtraData = Configuration.ToJson();           //TODO: extra configuration 필요한지 확인 필요

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::RequestItemListPurchasable(const FGamebasePurchasableItemListDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestItemListPurchasable };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::RequestItemListAtIAPConsole(const FGamebasePurchasableItemListDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestItemListAtIAPConsole };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::SetPromotionIAPHandler(const FGamebasePurchasableReceiptDelegate& Callback)
{
    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::SetPromotionIAPHandler };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::RequestActivatedPurchases(const FGamebasePurchasableReceiptListDelegate& Callback)
{
    const FGamebasePurchasableConfiguration Configuration;
    RequestActivatedPurchases(Configuration, Callback);
}

void FGamebaseBridgePurchase::RequestActivatedPurchases(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableReceiptListDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestActivatedPurchases };
    SendData.JsonData = Configuration.ToJson();
    SendData.ExtraData = Configuration.ToJson();           //TODO: extra configuration 필요한지 확인 필요

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgePurchase::RequestSubscriptionsStatus(const FGamebasePurchasableConfiguration& Configuration, const FGamebasePurchasableSubscriptionStatusDelegate& Callback)
{
}
