#include "GamebaseBridgeLaunching.h"

namespace GamebaseScheme
{
    const FName GetLaunchingInformations(TEXT("gamebase://getLaunchingInformations"));
    const FName GetLaunchingStatus(TEXT("gamebase://getLaunchingStatus"));
}

FGamebaseBridgeLaunching::FGamebaseBridgeLaunching(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

const FGamebaseLaunchingInfoPtr FGamebaseBridgeLaunching::GetLaunchingInformations() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetLaunchingInformations };

    const FString GetJsonString = Communicator->GetSync(SendData);
    if (GetJsonString.IsEmpty())
    {
        return nullptr;
    }
    
    const FGamebaseLaunchingInfoPtr LaunchingInfo = MakeShared<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>();
    LaunchingInfo->FromJson(GetJsonString);
    
    return LaunchingInfo;
}

int32 FGamebaseBridgeLaunching::GetLaunchingStatus() const
{
    const FGamebaseCommunicatorSendData SendData { GamebaseScheme::GetLaunchingStatus };

    const FString GetJsonString = Communicator->GetSync(SendData);
    if (GetJsonString.IsEmpty())
    {
        return 0;
    }

    return FCString::Atoi(*GetJsonString);
}
