#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseImageNotice.h"

class FGamebaseBridgeImageNotice : public IGamebaseImageNotice, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeImageNotice(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeImageNotice() override = default;
    
    virtual void ShowImageNotices(const FGamebaseImageNoticeConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback, const FGamebaseImageNoticeEventDelegate& EventCallback) override;
    virtual void CloseImageNotices() override;

private:
    int32 RegisterSchemeEvent(const FGamebaseImageNoticeEventDelegate& SchemeEvent);
    void UnregisterSchemeEvent(const FString& ExtraData);

private:
    TMap<int32, FGamebaseImageNoticeEventDelegate> OnSchemeEventMap;
};