#include "GamebaseBridgeGameNotice.h"

namespace GamebaseScheme
{
    static const FName OpenGameNotice(TEXT("gamebase://openGameNotice"));
}

FGamebaseBridgeGameNotice::FGamebaseBridgeGameNotice(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeGameNotice::OpenGameNotice(const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::OpenGameNotice };

    Communicator->GetAsync(SendData, Callback);
}