#pragma once

#include "GamebaseBridgeBase.h"
#include "Interfaces/IGamebaseEventHandler.h"

class FGamebaseBridgeEventHandler : public IGamebaseEventHandler, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeEventHandler(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeEventHandler() override = default;

    virtual FDelegateHandle AddHandler(const FGamebaseEventDelegate::FDelegate& EventCallback) override;
    virtual void RemoveHandler(const FDelegateHandle& EventHandle) override;
    virtual void RemoveAllHandler() override;

private:
    FGamebaseEventDelegate OnEvent;
};