#include "GamebaseBridgeEventHandler.h"
#include "GamebaseCommunicatorTypes.h"
#include "GamebaseDebugLogger.h"

namespace GamebaseScheme
{
    const FName AddEventHandler(TEXT("gamebase://addEventHandler"));
    const FName RemoveEventHandler(TEXT("gamebase://removeEventHandler"));
}

FGamebaseBridgeEventHandler::FGamebaseBridgeEventHandler(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
    Communicator->RegisterEvent(GamebaseScheme::AddEventHandler, [this](const FGamebaseCommunicatorReceiveDataPtr& ReceiveData)
    {
        const TSharedPtr<FGamebaseEventMessage, ESPMode::ThreadSafe> Message = MakeShared<FGamebaseEventMessage, ESPMode::ThreadSafe>();
        if (Message->FromJson(ReceiveData->JsonData) == false)
        {
            GAMEBASE_LOG_GLOBAL_WARNING("Failed to convert event messages to Json object");
            return;
        }

        OnEvent.Broadcast(*Message.Get());
    });
}

FDelegateHandle FGamebaseBridgeEventHandler::AddHandler(const FGamebaseEventDelegate::FDelegate& EventCallback)
{
    const FDelegateHandle Handle = OnEvent.Add(EventCallback);

    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::AddEventHandler };
    Communicator->GetSync(SendData);

    return Handle;
}

void FGamebaseBridgeEventHandler::RemoveHandler(const FDelegateHandle& EventHandle)
{
    if (OnEvent.Remove(EventHandle) == false)
    {
        GAMEBASE_LOG_GLOBAL_WARNING("Failed to remove the event handler");
    }

    const FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RemoveEventHandler };
    Communicator->GetSync(SendData);
}

void FGamebaseBridgeEventHandler::RemoveAllHandler()
{
    OnEvent.RemoveAll(this);
}
