#include "GamebaseBridgeCore.h"
#include "GamebaseCommunicationRequestTypes.h"

namespace GamebaseScheme
{
    const FName Initialize(TEXT("gamebase://initialize"));
    const FName SetDebugMode(TEXT("gamebase://setDebugMode"));
}

FGamebaseBridgeCore::FGamebaseBridgeCore(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

FGamebaseBridgeCore::~FGamebaseBridgeCore()
{
}

void FGamebaseBridgeCore::InitializeGamebase(const FGamebaseConfiguration& Configuration, const FGamebaseLaunchingInfoDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::Initialize };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgeCore::SetDebugMode(const bool bIsDebugMode)
{
    FIsDebugMode DebugMode;
    DebugMode.bIsDebugMode = bIsDebugMode;
    
    FGamebaseCommunicatorSendData SendData(GamebaseScheme::SetDebugMode);
    SendData.JsonData = DebugMode.ToJson(false);

    Communicator->GetAsync(SendData);
}