#include "GamebaseBridgeContact.h"

namespace GamebaseScheme
{
    const FName OpenContact(TEXT("gamebase://openContact"));
    const FName OpenContactWithConfiguration(TEXT("gamebase://openContactWithConfiguration"));
    const FName RequestContactURL(TEXT("gamebase://requestContactURL"));
    const FName RequestContactURLWithConfiguration(TEXT("gamebase://requestContactURLWithConfiguration"));
}

FGamebaseBridgeContact::FGamebaseBridgeContact(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeContact::OpenContact(const FGamebaseErrorDelegate& CloseCallback)
{
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::OpenContact };

    Communicator->GetAsync(SendData, CloseCallback);
}

void FGamebaseBridgeContact::OpenContact(const FGamebaseContactConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::OpenContactWithConfiguration };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, CloseCallback);
}

void FGamebaseBridgeContact::RequestContactURL(const FGamebaseContactUrlDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestContactURL };

    Communicator->GetAsync(SendData, Callback);
}

void FGamebaseBridgeContact::RequestContactURL(const FGamebaseContactConfiguration& Configuration, const FGamebaseContactUrlDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData{ GamebaseScheme::RequestContactURLWithConfiguration };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, Callback);
}
