#include "GamebaseBridgeCommunity.h"

namespace GamebaseScheme
{
    const FName OpenCommunityWithConfiguration(TEXT("gamebase://openCommunityWithConfiguration"));
}

FGamebaseBridgeCommunity::FGamebaseBridgeCommunity(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeCommunity::OpenCommunity(const FGamebaseCommunityConfiguration& Configuration, const FGamebaseErrorDelegate& Callback)
{
    FGamebaseCommunicatorSendData SendData { GamebaseScheme::OpenCommunityWithConfiguration };
    SendData.JsonData = Configuration.ToJson();

    Communicator->GetAsync(SendData, Callback);
}