#pragma once

#include "GamebaseAdapterCollection.h"
#include "GamebaseBridgeBase.h"
#include "GamebaseCoreAuthTypes.h"
#include "Interfaces/IGamebaseAuth.h"

class UGamebaseBridgeAuthAdapter;

class FGamebaseBridgeAuth : public IGamebaseAuth, public FGamebaseBridgeBase
{
public:
    explicit FGamebaseBridgeAuth(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName = {});
    virtual ~FGamebaseBridgeAuth() override = default;

    virtual void Login(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void Login(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void LoginForLastLoggedInProvider(const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    
    virtual void AddMapping(const FString& ProviderName, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FString& ProviderName, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMapping(const FGamebaseVariantMap& CredentialInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    
    virtual void ChangeLogin(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseForcingMappingTicket& ForcingMappingTicket, const FGamebaseAuthTokenDelegate& Callback) override;
    
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FString& ProviderName, const FString& ForcingMappingKey, const FGamebaseVariantMap& AdditionalInfo, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void AddMappingForcibly(const FGamebaseVariantMap& CredentialInfo, const FString& ForcingMappingKey, const FGamebaseAuthTokenDelegate& Callback) override;
    virtual void RemoveMapping(const FString& ProviderName, const FGamebaseErrorDelegate& Callback) override;

    virtual void Logout(const FGamebaseErrorDelegate& Callback) override;
    virtual void Withdraw(const FGamebaseErrorDelegate& Callback) override;
    virtual void WithdrawImmediately(const FGamebaseErrorDelegate& Callback) override;
    virtual void RequestTemporaryWithdrawal(const FGamebaseTemporaryWithdrawalDelegate& Callback) override;
    virtual void CancelTemporaryWithdrawal(const FGamebaseErrorDelegate& Callback) override;

    virtual void IssueTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void QueryTransferAccount(const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void RenewTransferAccount(const FGamebaseTransferAccountRenewConfiguration& Configuration, const FGamebaseTransferAccountDelegate& Callback) override;
    virtual void TransferAccountWithIdPLogin(const FString& AccountId, const FString& AccountPassword, const FGamebaseAuthTokenDelegate& Callback) override;

    virtual TArray<FString> GetAuthMappingList() override;
    virtual FString GetAuthProviderUserID(const FString& ProviderName) override;
    virtual FString GetAuthProviderAccessToken(const FString& ProviderName) override;
    virtual const FGamebaseAuthProviderProfilePtr GetAuthProviderProfile(const FString& ProviderName) override;

    virtual const FGamebaseBanInfoPtr GetBanInfo() override;

private:
    using FAuthAdapterCollection = TGamebaseAdapterCollection<UGamebaseBridgeAuthAdapter>;
    FAuthAdapterCollection LoadedAdapters;
};
