#include "GamebaseBridgeAnalytics.h"

namespace GamebaseScheme
{
    const FName SetGameUserData(TEXT("gamebase://setGameUserData"));
    const FName TraceLevelUp(TEXT("gamebase://traceLevelUp"));
}


FGamebaseBridgeAnalytics::FGamebaseBridgeAnalytics(const TSharedPtr<FGamebaseCommunicatorManager>& Communicator, const FName& ClassName)
    : FGamebaseBridgeBase(Communicator, ClassName)
{
}

void FGamebaseBridgeAnalytics::SetGameUserData(const FGamebaseAnalyticsUserData& GameUserData)
{
    FGamebaseCommunicatorSendData SendData(GamebaseScheme::SetGameUserData);
    SendData.JsonData = GameUserData.ToJson();

    Communicator->GetAsync(SendData);
}

void FGamebaseBridgeAnalytics::TraceLevelUp(const FGamebaseAnalyticsLevelUpData& LevelUpData)
{
    FGamebaseCommunicatorSendData SendData(GamebaseScheme::TraceLevelUp);
    SendData.JsonData = LevelUpData.ToJson();
    
    Communicator->GetAsync(SendData);
}
