#pragma once

#include "CoreMinimal.h"
#include "GamebaseCommunicatorDelegates.h"
#include "GamebaseCommunicatorTypes.h"

class IGamebaseCommunicator;

class FGamebaseCommunicatorManager final
    : public TSharedFromThis<FGamebaseCommunicatorManager>
{
public:
    explicit FGamebaseCommunicatorManager();
    ~FGamebaseCommunicatorManager();

    void Initialize(const FName& ClassName);
    
    void RegisterEvent(const FName& Scheme, const FGamebaseCommunicatorReceiveCallback& Callback);
    void ReceiveEvent(FGamebaseCommunicatorReceiveDataPtr Result);

    FString GetSync(const FGamebaseCommunicatorSendData& SendData);
    
    template<typename DelegateType = Gamebase::FVoidDelegate>
    void GetAsync(const FGamebaseCommunicatorSendData& SendData,
                  const DelegateType& ResponseCallback = Gamebase::FVoidDelegate(),
                  const FGamebaseCommunicatorExtraDataCallback& ExtraDataCallback = nullptr);

private:
    void RegisterAsyncEvent(FGamebaseCommunicatorSendData Data, const FGamebaseCommunicatorReceiveCallback& Callback);
    void RegisterHandleCallback(int32 Handle, const FGamebaseCommunicatorReceiveCallback& Callback);
    void UnregisterHandleCallback(int32 Handle);

private:
    FCriticalSection CriticalSection;
    TMap<int32, FGamebaseCommunicatorReceiveCallback> HandleCallbacks;
    TMap<FName, FGamebaseCommunicatorReceiveCallback> SchemeCallbacks;

    TUniquePtr<IGamebaseCommunicator> Communicator;
};

template <typename DelegateType>
void FGamebaseCommunicatorManager::GetAsync(
    const FGamebaseCommunicatorSendData& SendData,
    const DelegateType& ResponseCallback,
    const FGamebaseCommunicatorExtraDataCallback& ExtraDataCallback)
{
    RegisterAsyncEvent(SendData, Gamebase::MakeCallback(ResponseCallback, ExtraDataCallback));
}
