#pragma once

#include "CoreMinimal.h"
#include "GamebaseCommunicatorTypes.h"
#include "NhnJsonTraits.h"

namespace Gamebase
{
    namespace Communicator
    {
        /**
         * Converts FGamebaseCommunicatorReceiveDataRef to the specified type T.
         *
         * Usage:
         *   using namespace Gamebase::Communicator;
         *   int32 Value = Convert<int32>(ReceiveData);
         *   FString Str = Convert<FString>(ReceiveData);
         *   MyStruct Struct = Convert<MyStruct>(ReceiveData);
         *   TArray<FString> Arr = Convert<TArray<FString>>(ReceiveData);
         *   const MyStruct* Ptr = Convert<const MyStruct*>(ReceiveData);
         *   const TArray<MyStruct>* PtrArr = Convert<const TArray<MyStruct>*>(ReceiveData);
         *
         * Supported types:
         *   - int32, int64, uint32, uint64, float, double, bool, FString
         *   - TArray<T> (where T is a supported type)
         *   - ValueObject (structs with FromJson)
         *   - const ValueObject*
         *   - const TArray<ValueObject>*
         */
        template<typename T>
        FORCEINLINE T Convert(const FGamebaseCommunicatorReceiveDataRef& ReceiveData)
        {
            return NHN::Json::TConvertTraits<T>::Convert(ReceiveData->JsonData);
        }
    }
}