#pragma once

#include "CoreMinimal.h"
#include "GamebaseBridgeProvider.h"
#include "GamebaseCommunicatorManager.h"
#include "GamebaseDebugLogger.h"

class IGamebaseCommunicator
{
public:
    virtual ~IGamebaseCommunicator() = default;

    virtual void Initialize(const FName& ClassName) = 0;
    virtual void GetAsync(const FString& JsonString) = 0;
    virtual FString GetSync(const FString& JsonString) = 0;

    static void ReceiveMessage(const FString& JsonString)
    {
        GAMEBASE_LOG_GLOBAL_DEBUG("%s", *JsonString);

        const FGamebaseCommunicatorReceiveDataPtr ReceiveData = MakeShared<FGamebaseCommunicatorReceiveData, ESPMode::ThreadSafe>();
        if (ReceiveData->FromJson(JsonString) == false)
        {
            GAMEBASE_LOG_GLOBAL_ERROR("JSON parsing error. message object is null.");
            return;
        }

        if (const UGamebaseBridgeProvider* Provider = UGamebaseBridgeProvider::GetInstance())
        {
            if (FGamebaseCommunicatorManager* Communicator = Provider->GetCommunicator())
            {
                Communicator->ReceiveEvent(ReceiveData);
            }
        }
    }
};

class FGamebaseDummyCommunicator final : public IGamebaseCommunicator
{
public:
    virtual void Initialize(const FName& ClassName) override { checkNoEntry(); } 
    virtual void GetAsync(const FString& JsonString) override { checkNoEntry(); } 
    virtual FString GetSync(const FString& JsonString) override
    {
        checkNoEntry();
        return {};
    } 
};
