#pragma once

#include "GamebaseWebViewTypes.h"
#include "NhnJsonSerializable.h"

struct FIsDebugMode final : FNhnJsonSerializable
{
    bool bIsDebugMode;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("isDebugMode", bIsDebugMode);
    END_NHN_JSON_SERIALIZER
};

struct FAuthProviderInfo final : FNhnJsonSerializable
{
    FString ProviderName;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("providerName", ProviderName);
    END_NHN_JSON_SERIALIZER
};

struct FAuthAddMappingForcibly final : FNhnJsonSerializable
{
    FString ProviderName;
    FString ForcingMappingKey;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("providerName", ProviderName);
        NHN_JSON_SERIALIZE("forcingMappingKey", ForcingMappingKey);
    END_NHN_JSON_SERIALIZER
};

struct FAuthTransferAccount final : FNhnJsonSerializable
{
    FString AccountId;
    FString AccountPassword;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("accountId", AccountId);
        NHN_JSON_SERIALIZE("accountPassword", AccountPassword);
    END_NHN_JSON_SERIALIZER
};

struct FPurchaseItemSeq final : FNhnJsonSerializable
{
    int64 ItemSeq;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("itemSeq", ItemSeq);
    END_NHN_JSON_SERIALIZER
};

struct FPurchaseProductId final : FNhnJsonSerializable
{
    FString GamebaseProductId;
    FString Payload;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        NHN_JSON_SERIALIZE("payload", Payload);
    END_NHN_JSON_SERIALIZER
};

struct FUtilAlertDialog final : FNhnJsonSerializable
{
    FString Title;
    FString Message;
    int32 Duration;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("title", Title);
        NHN_JSON_SERIALIZE("message", Message);
        NHN_JSON_SERIALIZE("duration", Duration);
    END_NHN_JSON_SERIALIZER
};

struct FWebviewConfiguration final : FNhnJsonSerializable
{
    FString Url;
    FGamebaseWebViewConfiguration Configuration;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("url", Url);
        NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("configuration", Configuration);
    END_NHN_JSON_SERIALIZER
};

struct FWebviewSchemeExtraData final : FNhnJsonSerializable
{
    TArray<FString> SchemeList;
    int32 SchemeEvent;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE_ARRAY("schemeList", SchemeList);
        NHN_JSON_SERIALIZE("schemeEvent", SchemeEvent);
    END_NHN_JSON_SERIALIZER
};

struct FImageNoticeSchemeExtraData final : FNhnJsonSerializable
{
    int32 SchemeEvent;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("schemeEvent", SchemeEvent);
    END_NHN_JSON_SERIALIZER
};

struct FPushIsSandboxMode final : FNhnJsonSerializable
{
    bool bIsSandbox;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("isSandbox", bIsSandbox);
    END_NHN_JSON_SERIALIZER
};

struct FLoggerSendMessage final : FNhnJsonSerializable
{
    FString Message;
    TMap<FString, FString> UserFields;

    FLoggerSendMessage() = default;
    FLoggerSendMessage(const FString& Message, const TMap<FString, FString>& UserFields)
        : Message(Message)
        , UserFields(UserFields)
    {
    }
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("message", Message);
        NHN_JSON_SERIALIZE_MAP("userFields", UserFields);
    END_NHN_JSON_SERIALIZER
};

struct FLoggerUserField final : FNhnJsonSerializable
{
    FString Key;
    FString Value;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE("key", Key);
        NHN_JSON_SERIALIZE("value", Value);
    END_NHN_JSON_SERIALIZER
};

DECLARE_DELEGATE_OneParam(FGamebaseExtraDataDelegate, const FString&);