#include "GamebaseAndroidCommunicator.h"
#include "GamebaseDebugLogger.h"
#include "Dom/JsonObject.h"

#if USE_ANDROID_JNI

#include "Android/AndroidApplication.h"
#include "Android/AndroidJava.h"

#define COMMUNICATOR_CLASS "com/toast/android/gamebase/ue4/communicator/GamebaseMessageReceiver"

#define CHECK_JNI_METHOD(Id) checkf(Id != nullptr, TEXT("Failed to find " #Id));

void FGamebaseAndroidCommunicator::Initialize(const FName& className)
{
    JNIEnv* env = FAndroidApplication::GetJavaEnv();
    if (env != nullptr)
    {
        jclass pluginClass = FAndroidApplication::FindJavaClassGlobalRef(COMMUNICATOR_CLASS);
        if (pluginClass != nullptr)
        {
            jmethodID getInitMethod = env->GetStaticMethodID(pluginClass, "initialize", "(Ljava/lang/String;)V");
            CHECK_JNI_METHOD(getInitMethod);
            GAMEBASE_LOG_GLOBAL_WARNING("%s", *className.ToString());

            auto jStrClassName = FJavaHelper::ToJavaString(env, className.ToString());
            env->CallStaticVoidMethod(pluginClass, getInitMethod, *jStrClassName);
            env->DeleteGlobalRef(pluginClass);
        }
    }
}

void FGamebaseAndroidCommunicator::GetAsync(const FString& jsonString)
{
    JNIEnv* env = FAndroidApplication::GetJavaEnv();
    if (env != nullptr)
    {
        jclass pluginClass = FAndroidApplication::FindJavaClassGlobalRef(COMMUNICATOR_CLASS);
        if (pluginClass != nullptr)
        {
            jmethodID getAsyncMethod = env->GetStaticMethodID(pluginClass, "getAsync", "(Ljava/lang/String;)V");
            CHECK_JNI_METHOD(getAsyncMethod);

            GAMEBASE_LOG_GLOBAL_DEBUG("%s", *jsonString);

            auto jStrJsonValue = FJavaHelper::ToJavaString(env, jsonString);
            env->CallStaticVoidMethod(pluginClass, getAsyncMethod, *jStrJsonValue);

            env->DeleteGlobalRef(pluginClass);
        }
    }
}

FString FGamebaseAndroidCommunicator::GetSync(const FString& jsonString)
{
    FString result;

    JNIEnv* env = FAndroidApplication::GetJavaEnv();
    if (env != nullptr)
    {
        jclass pluginClass = FAndroidApplication::FindJavaClassGlobalRef(COMMUNICATOR_CLASS);
        if (pluginClass != nullptr)
        {
            jmethodID getSyncMethod = env->GetStaticMethodID(pluginClass, "getSync", "(Ljava/lang/String;)Ljava/lang/String;");

            GAMEBASE_LOG_GLOBAL_DEBUG("%s", *jsonString);

            auto jStrJsonValue = FJavaHelper::ToJavaString(env, jsonString);
            result = FJavaHelper::FStringFromLocalRef(env, (jstring)env->CallStaticObjectMethod(pluginClass, getSyncMethod, *jStrJsonValue));

            env->DeleteGlobalRef(pluginClass);
        }
    }

    GAMEBASE_LOG_GLOBAL_DEBUG("result: %s", *result);

    return result;
}

JNI_METHOD void Java_com_toast_android_gamebase_ue4_communicator_GamebaseMessageSender_nativeSendMessage(JNIEnv* jenv, jobject thiz, jstring inJsonString)
{
    IGamebaseCommunicator::ReceiveMessage(FJavaHelper::FStringFromParam(jenv, inJsonString));
}

#endif
