#pragma once

#include "CoreMinimal.h"
#include "GamebaseTypes.h"

struct GAMEBASE_API FGamebaseWebViewConfiguration final : FGamebaseValueObject
{
    FString Title;
    int32 Orientation;
    FColor NavigationColor = { 18, 93, 230, 255 };
    FColor NavigationTitleColor = FColor::White;
    TOptional<FColor> NavigationIconTintColor;
    int32 NavigationBarHeight = -1;
    bool bIsBackButtonVisible = true;
    bool bIsNavigationBarVisible = true;
    FString BackButtonImageResource;
    FString CloseButtonImageResource;
    int32 ContentMode;                           // iOS Only
    bool bEnableFixedFontSize = false;           // Android Only
    bool bRenderOutsideSafeArea = false;         // Android Only
    TOptional<FColor> CutoutColor;               // Android Only
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

DECLARE_DELEGATE_TwoParams(FGamebaseSchemeEventDelegate, const FString&, const FGamebaseError*);