#pragma once

#include "CoreMinimal.h"
#include "GamebaseError.h"
#include "GamebaseValueObject.h"

using FGamebaseLaunchingUpdateInfoPtr = TSharedPtr<struct FGamebaseLaunchingUpdateInfo, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseLaunchingUpdateInfo final : FGamebaseValueObject
{
    FString InstallUrl;
    FString Message;
    FString DetailUrl;

    static FGamebaseLaunchingUpdateInfoPtr From(const FGamebaseError* Error);

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


struct GAMEBASE_API FGamebaseLaunchingInfo final : FGamebaseValueObject
{
    struct GAMEBASE_API FLaunching final : FGamebaseValueObject
    {
        struct GAMEBASE_API FStatus final : FGamebaseValueObject
        {
            int32 Code;
            FString Message;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };
        
        struct GAMEBASE_API FApp final : FGamebaseValueObject
        {
            struct GAMEBASE_API FAccessInfo final : FGamebaseValueObject
            {
                FString ServerAddress;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FRelatedUrls final : FGamebaseValueObject
            {
                FString TermsUrl;
                FString PunishRuleUrl;
                FString PersonalInfoCollectionUrl;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FInstall final : FGamebaseValueObject
            {
                FString Url;
                FString DetailUrl;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FIdp final : FGamebaseValueObject
            {
                struct GAMEBASE_API FLoginWebView final : FGamebaseValueObject
                {
                    FString TitleBgColor;
                    FString TitleTextColor;
                    FString Title;
                    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
                };

                struct GAMEBASE_API FChannels final : FGamebaseValueObject
                {
                    FString Region;
                    FString ClientId;
                    FString ClientSecret;
                    
                    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
                };
                
                TOptional<FString> ClientId;
                TOptional<FString> ClientSecret;
                TOptional<FString> Additional;
                TOptional<FString> CallbackUrl;
                TOptional<FLoginWebView> LoginWebView;
                TArray<FChannels> Channels;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FLoginUrls final : FGamebaseValueObject
            {
                FString GamebaseUrl;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FLanguage final : FGamebaseValueObject
            {
                FString DeviceLanguage;
                FString DefaultLanguage;
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
            
            struct GAMEBASE_API FCustomerService final : FGamebaseValueObject
            {
                FString Type;
                FString Url;
                FString AccessInfo;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };

            struct GAMEBASE_API FTermsService final : FGamebaseValueObject
            {
                bool bShowTermsFlag;
                FString TermsUrl;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };

            struct GAMEBASE_API FGameNotice final : FGamebaseValueObject
            {
                FString Url;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
        
            FAccessInfo AccessInfo;
            TMap<FString, FIdp> Idp;
            FInstall Install;
            FRelatedUrls RelatedUrls;
            FLanguage Language;
            FString StoreCode;
            FString TypeCode;
            FLoginUrls LoginUrls;
            TOptional<FCustomerService> CustomerService;
            TOptional<FGameNotice> GameNotice;
            TOptional<FTermsService> TermsService;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };
        
        struct GAMEBASE_API FMaintenance final : FGamebaseValueObject
        {
            FString Url;
            FString TypeCode;
            FString PageTypeCode;
            FString Reason;
            FString Message;
            FString Timezone;
            FString BeginDate;
            FString EndDate;
            int64 LocalBeginDate;
            int64 LocalEndDate;
            bool bHideDate;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };

        struct GAMEBASE_API FNotice final : FGamebaseValueObject
        {
            FString Message;
            FString Title;
            FString Url;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };

        struct GAMEBASE_API FUser final : FGamebaseValueObject
        {
            struct GAMEBASE_API FTestDevice final : FGamebaseValueObject
            {
                bool bMatchingFlag;
                TArray<FString> MatchingTypes;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };

            TOptional<FTestDevice> TestDevice;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };
        
        struct GAMEBASE_API FTcgbClient final : FGamebaseValueObject
        {
            struct GAMEBASE_API FStability final : FGamebaseValueObject
            {
                bool bUseFlag;
                bool bUseFlagSpecificUser;
                FString LogLevel;
                FString AppKey;
                int64 AppKeyVersion;
                int32 InitFailCount;
                TArray<FString> SecurityBlacklist;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };

            struct GAMEBASE_API FForceRemoteSettings final : FGamebaseValueObject
            {
                struct GAMEBASE_API FLog final : FGamebaseValueObject
                {
                    FString Policy;
                    FString Indicator;
                    FString Reason;
                    FString AppKeyIndicator;
                    FString AppKeyLog;
                    
                    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
                };

                FLog Log;
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };
                
            struct GAMEBASE_API FIntrospection final : FGamebaseValueObject
            {
                int32 IntervalSeconds;
                
                virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
            };  
            
            FStability Stability;
            TOptional<FForceRemoteSettings> ForceRemoteSettings;
            TOptional<FIntrospection> Introspection;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };
        
        FStatus Status;
        FApp App;
        TOptional<FMaintenance> Maintenance;
        TOptional<FNotice> Notice;
        TOptional<FTcgbClient> TcgbClient;
        TOptional<FUser> User;
        
        virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
    };
    
    struct GAMEBASE_API FTcProductInfo final : FGamebaseValueObject
    {
        struct GAMEBASE_API FAppKeyInfo : FGamebaseValueObject
        {
            FString AppKey;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };

        struct GAMEBASE_API FIapInfo final : FAppKeyInfo
        {
            FString Url;
            
            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };

        FAppKeyInfo Gamebase;
        FAppKeyInfo TcLaunching;
        FIapInfo Iap;
        FAppKeyInfo Push;
        virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
    };
    
    struct GAMEBASE_API FTcIapInfo final : FGamebaseValueObject
    {
        FString Id;
        FString Name;
        FString StoreCode;
        FString StoreAppId;
        
        virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
    };
    
    FLaunching Launching;
    FTcProductInfo TcProduct;
    TArray<FTcIapInfo> TcIap;
    TOptional<FString> TcLaunching;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseLaunchingInfoPtr = TSharedPtr<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>;
using FGamebaseLaunchingInfoRef = TSharedRef<FGamebaseLaunchingInfo, ESPMode::ThreadSafe>;

DECLARE_DELEGATE_TwoParams(FGamebaseLaunchingInfoDelegate, const FGamebaseLaunchingInfo* /*launchingInfo*/, const FGamebaseError* /*error*/);