#pragma once

#include "CoreMinimal.h"
#include "GamebaseError.h"

struct GAMEBASE_API FGamebaseImageNoticeConfiguration final : FGamebaseValueObject
{
    FColor BackgroundColor = { 0, 0, 0, 128 };
    int64 TimeOut = 5000;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

DECLARE_DELEGATE_TwoParams(FGamebaseImageNoticeEventDelegate, const FString&, const FGamebaseError*);