#pragma once

#include "CoreMinimal.h"
#include "GamebasePurchaseTypes.h"

using FGamebaseEventMessagePtr = TSharedPtr<struct FGamebaseEventMessage, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventMessage final : FGamebaseValueObject
{
    FString Category;
    FString Data;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseEventServerPushDataPtr = TSharedPtr<struct FGamebaseEventServerPushData, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventServerPushData final : FGamebaseValueObject
{
    struct GAMEBASE_API FPopup final : FGamebaseValueObject
    {
        struct GAMEBASE_API FMessage final : FGamebaseValueObject
        {
            FString Message;
            FString Title;

            virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
        };

        FString DefaultLanguage;
        TMap<FString, FMessage> Messages;
        
        virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
    };

    FString Extras;
    TOptional<FPopup> Popup;
    
    static FGamebaseEventServerPushDataPtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseEventObserverDataPtr = TSharedPtr<struct FGamebaseEventObserverData, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventObserverData final : FGamebaseValueObject
{
    int32 Code;
    FString Extras;
    FString Message;

    static FGamebaseEventObserverDataPtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

struct GAMEBASE_API FGamebaseEventPurchasableReceipt final : FGamebasePurchasableReceipt
{
    static FGamebasePurchasableReceiptPtr From(const FString& JsonString);
};


using FGamebaseEventPushMessagePtr = TSharedPtr<struct FGamebaseEventPushMessage, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventPushMessage final : FGamebaseValueObject
{
    FString Body;
    FString Extras;
    FString Id;
    FString Title;

    static FGamebaseEventPushMessagePtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseEventPushActionPtr = TSharedPtr<struct FGamebaseEventPushAction, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventPushAction final : FGamebaseValueObject
{
    FString ActionType;
    FGamebaseEventPushMessage Message;
    FString UserText;

    static FGamebaseEventPushActionPtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseEventLoggedOutDataPtr = TSharedPtr<struct FGamebaseEventLoggedOutData, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventLoggedOutData final : FGamebaseValueObject
{
    FString message;
    FString extras;

    static FGamebaseEventLoggedOutDataPtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

using FGamebaseEventIdPRevokedDataPtr = TSharedPtr<struct FGamebaseEventIdPRevokedData, ESPMode::ThreadSafe>;

struct GAMEBASE_API FGamebaseEventIdPRevokedData final : FGamebaseValueObject
{
    int32 Code;
    FString IdpType;
    TArray<FString> AuthMappingList;
    FString Extras;

    static FGamebaseEventIdPRevokedDataPtr From(const FString& JsonString);
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};


DECLARE_MULTICAST_DELEGATE_OneParam(FGamebaseEventDelegate, const FGamebaseEventMessage&);
using FGamebaseEventHandleDelegate = FGamebaseEventDelegate::FDelegate;