#pragma once

#include "CoreMinimal.h"
#include "GamebaseError.h"

struct GAMEBASE_API FGamebaseContactConfiguration final : FGamebaseValueObject
{
    FString UserName;
    TMap<FString, FString> ExtraData;
    FString AdditionalURL;
    TMap<FString, FString> AdditionalParameters;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

DECLARE_DELEGATE_TwoParams(FGamebaseContactUrlDelegate, FString, const FGamebaseError*);
