#pragma once

#include "CoreMinimal.h"
#include "GamebaseValueObject.h"

struct GAMEBASE_API FGamebaseConfiguration final : FGamebaseValueObject
{
    FString AppID;
    FString AppVersion;
    FString ZoneType;
    FString DisplayLanguageCode;
    bool bEnablePopup = false;
    bool bEnableLaunchingStatusPopup = true;
    bool bEnableBanPopup = true;
    FString StoreCode;
    FString PushType;
    bool bEnableGPGSSignInCheck = true;

    FGamebaseConfiguration() = default;
    FGamebaseConfiguration(const FGamebaseConfiguration& Other) = default;
    FGamebaseConfiguration(FGamebaseConfiguration&& Other) = default;
    FGamebaseConfiguration& operator=(const FGamebaseConfiguration& Other) = default;
    FGamebaseConfiguration& operator=(FGamebaseConfiguration&& Other) = default;

    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};
