#pragma once

#include "CoreMinimal.h"
#include "GamebaseValueObject.h"

struct GAMEBASE_API FGamebaseAnalyticsUserData final : FGamebaseValueObject
{
    int32 UserLevel;
    FString ChannelId;
    FString CharacterId;
    FString CharacterClassId;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};

struct GAMEBASE_API FGamebaseAnalyticsLevelUpData final : FGamebaseValueObject
{
    int32 UserLevel;
    int64 LevelUpTime;
    
    virtual void Serialize(FJsonSerializerBase& Serializer, bool bFlatObject) override;
};
