#pragma once

#include "CoreMinimal.h"
#include "Types/GamebaseNetworkTypes.h"

class GAMEBASE_API IGamebaseNetwork
{
public:
    virtual ~IGamebaseNetwork() = default;

    /**
     * Reports the type of network to which the info in this NetworkInfo pertains.
     *
     * @return  One of EGamebaseNetworkType::Not, EGamebaseNetworkType::Mobile, EGamebaseNetworkType::Wifi, EGamebaseNetworkType::Any.
     */
    virtual EGamebaseNetworkType GetNetworkType() const = 0;

    /**
     * Return a human-readable name describe the type of the network, for example "WIFI" or "MOBILE".
     *
     * @return the name of the network type.
     */
    virtual FString GetNetworkTypeName() const = 0;

    /**
     * Indicates whether network connectivity exists and it is possible to establish connections and pass data.
     *
     * @return true if network connectivity exists, false otherwise.
     */
    virtual bool IsConnected() const = 0;
};