#pragma once

#include "Types/GamebaseLaunchingTypes.h"

class GAMEBASE_API IGamebaseLaunching
{
public:
    virtual ~IGamebaseLaunching() = default;

    /**
     * Get various information provided by the launching server.
     *
     * @return  The Launching information.
     */
    virtual const FGamebaseLaunchingInfoPtr GetLaunchingInformations() const = 0;

    /**
     * Gets the launching state.
     *
     * @return  The launching status.
     * @see     GamebaseLaunchingStatus
     */
    virtual int32 GetLaunchingStatus() const = 0;
};
