#pragma once

#include "Types/GamebaseImageNoticeTypes.h"

class GAMEBASE_API IGamebaseImageNotice
{
public:
    virtual ~IGamebaseImageNotice() = default;

    /**
     * Show image notice web pages.
     *
     * @param Configuration     The initial settings of image notices.
     * @param CloseCallback     called when the browser closed.
     * @param EventCallback     Click event with notice type 'Custom'.
     *
     * Example Usage:
     * @code
     *  void ShowImageNoticesSample(int32 BackgroundColorR, int32 BackgroundColorG, int32 BackgroundColorB, int32 BackgroundColorA, int64 TimeOut)
     *  {
     *      FGamebaseImageNoticeConfiguration Configuration;
     *      Configuration.BackgroundColor = BackgroundColor;
     *      Configuration.TimeOut = TimeOut;
     *      
     *      UGamebaseSubsystem* GamebaseSubsystem = UGameInstance::GetSubsystem<UGamebaseSubsystem>(GetGameInstance());
     *      GamebaseSubsystem->GetImageNotice()->ShowImageNotices(Configuration,
     *          FGamebaseErrorDelegate::CreateLambda([=](const FGamebaseError* Error) {
     *              UE_LOG(GamebaseTestResults, Display, TEXT("Close image notice."));
     *          }),
     *          FGamebaseSchemeEventDelegate::CreateLambda([=](const FString& scheme, const FGamebaseError* error) {
     *              if (Gamebase::IsSuccess(Error))
     *              {
     *                  UE_LOG(GamebaseTestResults, Display, TEXT("scheme= %s"), *scheme);
     *              }
     *              else
     *              {
     *                  UE_LOG(GamebaseTestResults, Display, TEXT("ImageNotice scheme failed. (Error: %d)"), Error->code);
     *              }
     *          })
     *      );
     *  }
     * @endcode
     */
    virtual void ShowImageNotices(const FGamebaseImageNoticeConfiguration& Configuration, const FGamebaseErrorDelegate& CloseCallback, const FGamebaseImageNoticeEventDelegate& EventCallback = {}) = 0;

    /**
     * This method to close the image notice in display on a screen.
     */
    virtual void CloseImageNotices() = 0;
};