#pragma once

#include "GamebaseCommunityTypes.h"

class GAMEBASE_API IGamebaseGameNotice
{
public:
    virtual ~IGamebaseGameNotice() = default;
    
    /**
     * Send a game user data to Gamebase Server for analyzing the data.
     * This method should be called after login.
     *
     * @param Callback 
     *
     * @code
     *  void OpenGameNotice()
     *  {
     *      
     *      UGamebaseSubsystem* GamebaseSubsystem = UGameInstance::GetSubsystem<UGamebaseSubsystem>(GetGameInstance());
     *      GamebaseSubsystem->GetGameNotice()->OpenGameNotice(FGamebaseErrorDelegate::CreateLambda([=](const FGamebaseError* Error)
     *      {
     *          if (Gamebase::IsSuccess(Error))
     *          {
     *              UE_LOG(GamebaseTestResults, Display, TEXT("OpenGameNotice succeeded."));
     *          }
     *          else
     *          {
     *              UE_LOG(GamebaseTestResults, Display, TEXT("OpenGameNotice failed./n%s)"), *Error->ToPrettyJson());
     *          }
     *      }));
     *  }
     * @endcode
     */
    virtual void OpenGameNotice(const FGamebaseErrorDelegate& Callback) = 0;
};
