#pragma once

#include "GamebaseCommunityTypes.h"

class GAMEBASE_API IGamebaseCommunity
{
public:
    virtual ~IGamebaseCommunity() = default;
    
    /**
     * Send a game user data to Gamebase Server for analyzing the data.
     * This method should be called after login.
     *
     * @param Configuration 
     * @param Callback 
     *
     * @code
     *  void OpenCommunity(const FString& ForcedURL)
     *  {
     *      FGamebaseCommunityConfiguration Configuration;
     *      Configuration.ForcedURL = ForcedUrl;
     *      
     *      UGamebaseSubsystem* GamebaseSubsystem = UGameInstance::GetSubsystem<UGamebaseSubsystem>(GetGameInstance());
     *      GamebaseSubsystem->GetCommunity()->OpenCommunity(Configuration, FGamebaseErrorDelegate::CreateLambda([=](const FGamebaseError* Error)
     *      {
     *          if (Gamebase::IsSuccess(Error))
     *          {
     *              UE_LOG(GamebaseTestResults, Display, TEXT("OpenCommunity succeeded."));
     *          }
     *          else
     *          {
     *              UE_LOG(GamebaseTestResults, Display, TEXT("OpenCommunity failed./n%s)"), *Error->ToPrettyJson());
     *          }
     *      }));
     *  }
     * @endcode
     */
    virtual void OpenCommunity(const FGamebaseCommunityConfiguration& Configuration, const FGamebaseErrorDelegate& Callback) = 0;
};
