#include "GamebaseWebViewTypes.h"

#include "NhnJsonSerializeMacros.h"

void FGamebaseWebViewConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("title", Title);
    NHN_JSON_SERIALIZE("orientation", Orientation);
    NHN_JSON_SERIALIZE_COLOR("navigationColor", NavigationColor);
    NHN_JSON_SERIALIZE_COLOR("navigationTitleColor", NavigationTitleColor);
    NHN_JSON_SERIALIZE_COLOR_OPTIONAL("navigationIconTintColor", NavigationIconTintColor);
    NHN_JSON_SERIALIZE("barHeight", NavigationBarHeight);
    NHN_JSON_SERIALIZE("isBackButtonVisible", bIsBackButtonVisible);
    NHN_JSON_SERIALIZE("isNavigationBarVisible", bIsNavigationBarVisible);
    NHN_JSON_SERIALIZE("backButtonImageResource", BackButtonImageResource);
    NHN_JSON_SERIALIZE("closeButtonImageResource", CloseButtonImageResource);
    NHN_JSON_SERIALIZE("contentMode", ContentMode);
    NHN_JSON_SERIALIZE("enableFixedFontSize", bEnableFixedFontSize);
    NHN_JSON_SERIALIZE("renderOutsideSafeArea", bRenderOutsideSafeArea);
    NHN_JSON_SERIALIZE_COLOR_OPTIONAL("cutoutColor", CutoutColor);
    END_NHN_VO_SERIALIZER
}
