﻿#include "GamebaseTermsTypes.h"

#include "NhnJsonSerializeMacros.h"

void FGamebaseTermsConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("forceShow", bForceShow);
    NHN_JSON_SERIALIZE("enableFixedFontSize", bEnableFixedFontSize);
    END_NHN_VO_SERIALIZER
}

void FGamebaseTermsContent::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
    NHN_JSON_SERIALIZE("agreed", bAgreed);
    END_NHN_VO_SERIALIZER
}

void FGamebaseUpdateTermsConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("termsSeq", TermsSeq);
    NHN_JSON_SERIALIZE("termsVersion", TermsVersion);
    NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FGamebaseTermsContent);
    END_NHN_VO_SERIALIZER
}

void FGamebaseQueryTermsResult::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("termsVersion", TermsVersion);
    NHN_JSON_SERIALIZE("termsSeq", TermsSeq);
    NHN_JSON_SERIALIZE("termsCountryType", TermsCountryType);
    NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("contents", Contents, FContentDetail);
    END_NHN_VO_SERIALIZER
}

void FGamebaseQueryTermsResult::FContentDetail::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("termsContentSeq", TermsContentSeq);
    NHN_JSON_SERIALIZE("agreed", bAgreed);
    NHN_JSON_SERIALIZE("required", bRequired);
    NHN_JSON_SERIALIZE("name", Name);
    NHN_JSON_SERIALIZE("agreePush", AgreePush);
    NHN_JSON_SERIALIZE("node1DepthPosition", Node1DepthPosition);
    NHN_JSON_SERIALIZE("node2DepthPosition", Node2DepthPosition);
    NHN_JSON_SERIALIZE("detailPageUrl", DetailPageUrl);
    END_NHN_VO_SERIALIZER
}

FGamebaseShowTermsViewResultPtr FGamebaseShowTermsViewResult::From(const FGamebaseDataContainer* DataContainer)
{
    if (DataContainer == nullptr || DataContainer->Data.IsEmpty())
    {
        return nullptr;
    }

    const FGamebaseShowTermsViewResultPtr ShowTermsViewResult = MakeShared<FGamebaseShowTermsViewResult, ESPMode::ThreadSafe>();
    ShowTermsViewResult->FromJson(DataContainer->Data);
    
    return ShowTermsViewResult;
}

void FGamebaseShowTermsViewResult::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("isTermsUIOpened", bIsTermsUIOpened);
    END_NHN_VO_SERIALIZER
}
