#include "GamebasePurchaseTypes.h"

#include "NhnJsonSerializeMacros.h"

void FGamebasePurchasableConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("allStores", bAllStores);
    NHN_JSON_SERIALIZE("includeExpiredSubscriptions", bIncludeExpiredSubscriptions);
    END_NHN_VO_SERIALIZER
}

void FGamebasePurchasableItem::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
    NHN_JSON_SERIALIZE("itemSeq", ItemSeq);
    NHN_JSON_SERIALIZE("price", Price);
    NHN_JSON_SERIALIZE("currency", Currency);
    NHN_JSON_SERIALIZE("itemName", ItemName);
    NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
    NHN_JSON_SERIALIZE("productType", ProductType);
    NHN_JSON_SERIALIZE("localizedPrice", LocalizedPrice);
    NHN_JSON_SERIALIZE("localizedTitle", LocalizedTitle);
    NHN_JSON_SERIALIZE("localizedDescription", LocalizedDescription);
    NHN_JSON_SERIALIZE("isActive", bIsActive);
    END_NHN_VO_SERIALIZER
}

void FGamebasePurchasableReceipt::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
    NHN_JSON_SERIALIZE("itemSeq", ItemSeq);
    NHN_JSON_SERIALIZE("price", Price);
    NHN_JSON_SERIALIZE("currency", Currency);
    NHN_JSON_SERIALIZE("paymentSeq", PaymentSeq);
    NHN_JSON_SERIALIZE("purchaseToken", PurchaseToken);
    NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
    NHN_JSON_SERIALIZE("productType", ProductType);
    NHN_JSON_SERIALIZE("userId", UserId);
    NHN_JSON_SERIALIZE("paymentId", PaymentId);
    NHN_JSON_SERIALIZE_OPTIONAL("originalPaymentId", OriginalPaymentId);
    NHN_JSON_SERIALIZE("purchaseTime", PurchaseTime);
    NHN_JSON_SERIALIZE("expiryTime", ExpiryTime);
    NHN_JSON_SERIALIZE("storeCode", StoreCode);
    NHN_JSON_SERIALIZE_OPTIONAL("payload", Payload);
    NHN_JSON_SERIALIZE_OPTIONAL("isPromotion", bIsPromotion);
    NHN_JSON_SERIALIZE_OPTIONAL("isTestPurchase", bIsTestPurchase);
    END_NHN_VO_SERIALIZER
}

void FGamebasePurchasableSubscriptionStatus::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
    NHN_JSON_SERIALIZE("itemSeq", ItemSeq);
    NHN_JSON_SERIALIZE("storeCode", StoreCode);
    NHN_JSON_SERIALIZE("paymentId", PaymentId);
    NHN_JSON_SERIALIZE_OPTIONAL("originalPaymentId", OriginalPaymentId);
    NHN_JSON_SERIALIZE("paymentSeq", PaymentSeq);
    NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
    NHN_JSON_SERIALIZE("productType", ProductType);
    NHN_JSON_SERIALIZE("userId", UserId);
    NHN_JSON_SERIALIZE("price", Price);
    NHN_JSON_SERIALIZE("currency", Currency);
    NHN_JSON_SERIALIZE("purchaseToken", PurchaseToken);
    NHN_JSON_SERIALIZE("purchaseTime", PurchaseTime);
    NHN_JSON_SERIALIZE("expiryTime", ExpiryTime);
    NHN_JSON_SERIALIZE("statusCode", StatusCode);
    NHN_JSON_SERIALIZE("statusDescription", StatusDescription);
    NHN_JSON_SERIALIZE_OPTIONAL("payload", Payload);
    NHN_JSON_SERIALIZE_OPTIONAL("purchaseType", PurchaseType);
    END_NHN_VO_SERIALIZER
}
