#include "GamebaseLoggerTypes.h"

#include "NhnJsonSerializeMacros.h"

void FGamebaseLoggerConfiguration::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("appKey", AppKey);
    NHN_JSON_SERIALIZE("enableCrashReporter", bEnableCrashReporter);
    NHN_JSON_SERIALIZE("zoneType", ZoneType);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLogEntry::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    int32 ConvertLogLevel = static_cast<int32>(LogLevel);
    
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("logType", LogType);
    NHN_JSON_SERIALIZE("logLevel", ConvertLogLevel);
    NHN_JSON_SERIALIZE("transactionId", TransactionId);
    NHN_JSON_SERIALIZE("createTime", CreateTime);
    NHN_JSON_SERIALIZE_MAP("userFields", UserFields);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLogFilter::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("name", Name);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLoggerEngineCrashData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    int32 ConvertLogLevel = static_cast<int32>(LogLevel);
    
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("logLevel", ConvertLogLevel);
    NHN_JSON_SERIALIZE("condition", Condition);
    NHN_JSON_SERIALIZE("stackTrace", StackTrace);
    END_NHN_VO_SERIALIZER
}