#include "GamebaseLaunchingTypes.h"

#include "NhnJsonSerializeMacros.h"

namespace GamebaseErrorExtras
{
    const FString UpdateInfo{ TEXT("updateInfo") };
}

FGamebaseLaunchingUpdateInfoPtr FGamebaseLaunchingUpdateInfo::From(const FGamebaseError* Error)
{
    if (Error == nullptr)
    {
        return nullptr;
    }
    
    const TOptional<FString>& JsonString = Error->FindExtra(GamebaseErrorExtras::UpdateInfo);
    if (!JsonString.IsSet())
    {
        return nullptr;
    }
    
    const FGamebaseLaunchingUpdateInfoPtr LaunchingUpdateInfo = MakeShared<FGamebaseLaunchingUpdateInfo, ESPMode::ThreadSafe>();
    LaunchingUpdateInfo->FromJson(JsonString.GetValue());
    
    return LaunchingUpdateInfo;
}

void FGamebaseLaunchingUpdateInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("installUrl", InstallUrl);
    NHN_JSON_SERIALIZE("message", Message);
    NHN_JSON_SERIALIZE("detailUrl", DetailUrl);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("launching", Launching);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tcProduct", TcProduct);
    NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("tcIap", TcIap, FTcIapInfo);
    NHN_JSON_SERIALIZE_OPTIONAL("tcLaunching", TcLaunching);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FStatus::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("code", Code);
    NHN_JSON_SERIALIZE("message", Message);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FAccessInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("serverAddress", ServerAddress);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FRelatedUrls::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("termsUrl", TermsUrl);
    NHN_JSON_SERIALIZE("punishRuleUrl", PunishRuleUrl);
    NHN_JSON_SERIALIZE("personalInfoCollectionUrl", PersonalInfoCollectionUrl);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FInstall::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("url", Url);
    NHN_JSON_SERIALIZE("detailUrl", DetailUrl);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FIdp::FLoginWebView::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("titleBgColor", TitleBgColor);
    NHN_JSON_SERIALIZE("titleTextColor", TitleTextColor);
    NHN_JSON_SERIALIZE("title", Title);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FIdp::FChannels::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("region", Region);
    NHN_JSON_SERIALIZE("clientId", ClientId);
    NHN_JSON_SERIALIZE("clientSecret", ClientSecret);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FIdp::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OPTIONAL("clientId", ClientId);
    NHN_JSON_SERIALIZE_OPTIONAL("clientSecret", ClientSecret);
    NHN_JSON_SERIALIZE_OPTIONAL("additional", Additional);
    NHN_JSON_SERIALIZE_OPTIONAL("callbackUrl", CallbackUrl);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("loginWebView", LoginWebView);
    NHN_JSON_SERIALIZE_ARRAY_SERIALIZABLE("channels", Channels, FChannels);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FLoginUrls::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("gamebaseUrl", GamebaseUrl);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FLanguage::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("deviceLanguage", DeviceLanguage);
    NHN_JSON_SERIALIZE("defaultLanguage", DefaultLanguage);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FCustomerService::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("type", Type);
    NHN_JSON_SERIALIZE("url", Url);
    NHN_JSON_SERIALIZE("accessInfo", AccessInfo);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FTermsService::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("showTermsFlag", bShowTermsFlag);
    NHN_JSON_SERIALIZE("termsUrl", TermsUrl);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::FGameNotice::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("url", Url);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FApp::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("accessInfo", AccessInfo);
    NHN_JSON_SERIALIZE_MAP_SERIALIZABLE("idP", Idp, FIdp);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("install", Install);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("relatedUrls", RelatedUrls);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("language", Language);
    NHN_JSON_SERIALIZE("storeCode", StoreCode);
    NHN_JSON_SERIALIZE("typeCode", TypeCode);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("loginUrls", LoginUrls);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("customerService", CustomerService);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("gameNotice", GameNotice);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("termsService", TermsService);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FMaintenance::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("url", Url);
    NHN_JSON_SERIALIZE("typeCode", TypeCode);
    NHN_JSON_SERIALIZE("pageTypeCode", PageTypeCode);
    NHN_JSON_SERIALIZE("reason", Reason);
    NHN_JSON_SERIALIZE("message", Message);
    NHN_JSON_SERIALIZE("timezone", Timezone);
    NHN_JSON_SERIALIZE("beginDate", BeginDate);
    NHN_JSON_SERIALIZE("endDate", EndDate);
    NHN_JSON_SERIALIZE("localBeginDate", LocalBeginDate);
    NHN_JSON_SERIALIZE("localEndDate", LocalEndDate);
    NHN_JSON_SERIALIZE("hideDate", bHideDate);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FNotice::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("message", Message);
    NHN_JSON_SERIALIZE("title", Title);
    NHN_JSON_SERIALIZE("url", Url);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FUser::FTestDevice::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("matchingFlag", bMatchingFlag);
    NHN_JSON_SERIALIZE_ARRAY("matchingTypes", MatchingTypes);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FUser::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("testDevice", TestDevice);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FTcgbClient::FStability::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("useFlag", bUseFlag);
    NHN_JSON_SERIALIZE("useFlagSpecificUser", bUseFlagSpecificUser);
    NHN_JSON_SERIALIZE("logLevel", LogLevel);
    NHN_JSON_SERIALIZE("appKey", AppKey);
    NHN_JSON_SERIALIZE("appKeyVersion", AppKeyVersion);
    NHN_JSON_SERIALIZE("initFailCount", InitFailCount);
    NHN_JSON_SERIALIZE_ARRAY("securityBlacklist", SecurityBlacklist);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FTcgbClient::FForceRemoteSettings::FLog::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("policy", Policy);
    NHN_JSON_SERIALIZE("indicator", Indicator);
    NHN_JSON_SERIALIZE("reason", Reason);
    NHN_JSON_SERIALIZE("appKeyIndicator", AppKeyIndicator);
    NHN_JSON_SERIALIZE("appKeyLog", AppKeyLog);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FTcgbClient::FForceRemoteSettings::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("log", Log);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FTcgbClient::FIntrospection::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("intervalSeconds", IntervalSeconds);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::FTcgbClient::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("stability", Stability);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("forceRemoteSettings", ForceRemoteSettings);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("introspection", Introspection);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FLaunching::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("status", Status);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("app", App);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("user", User);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("maintenance", Maintenance);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("notice", Notice);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("tcgbClient", TcgbClient);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FTcProductInfo::FAppKeyInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("appKey", AppKey);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FTcProductInfo::FIapInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    FAppKeyInfo::Serialize(Serializer, bFlatObject);
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("url", Url);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FTcProductInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("gamebase", Gamebase);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("tcLaunching", TcLaunching);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("iap", Iap);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("push", Push);
    END_NHN_VO_SERIALIZER
}

void FGamebaseLaunchingInfo::FTcIapInfo::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("id", Id);
    NHN_JSON_SERIALIZE("name", Name);
    NHN_JSON_SERIALIZE("storeCode", StoreCode);
    NHN_JSON_SERIALIZE("storeAppId", StoreAppId);
    END_NHN_VO_SERIALIZER
}