#include "GamebaseEventTypes.h"

#include "NhnJsonSerializeMacros.h"

void FGamebaseEventMessage::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("category", Category);
    NHN_JSON_SERIALIZE("data", Data);
    END_NHN_VO_SERIALIZER
}

FGamebaseEventServerPushDataPtr FGamebaseEventServerPushData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventServerPushDataPtr ServerPushData = MakeShared<FGamebaseEventServerPushData, ESPMode::ThreadSafe>();
    ServerPushData->FromJson(JsonString);
    
    return ServerPushData;
}

void FGamebaseEventServerPushData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("extras", Extras);
    NHN_JSON_SERIALIZE_OPTIONAL_OBJECT_SERIALIZABLE("popup", Popup);
    END_NHN_VO_SERIALIZER
}

void FGamebaseEventServerPushData::FPopup::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("defaultLanguage", DefaultLanguage);
    NHN_JSON_SERIALIZE_MAP_SERIALIZABLE("messages", Messages, FMessage);
    END_NHN_VO_SERIALIZER
}

void FGamebaseEventServerPushData::FPopup::FMessage::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("message", Message);
    NHN_JSON_SERIALIZE("title", Title);
    END_NHN_VO_SERIALIZER
}

FGamebaseEventObserverDataPtr FGamebaseEventObserverData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }

    const FGamebaseEventObserverDataPtr ObserverData = MakeShared<FGamebaseEventObserverData, ESPMode::ThreadSafe>();
    ObserverData->FromJson(JsonString);
    
    return ObserverData;
}

void FGamebaseEventObserverData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("code", Code);
    NHN_JSON_SERIALIZE("extras", Extras);
    NHN_JSON_SERIALIZE("message", Message);
    END_NHN_VO_SERIALIZER
}

FGamebasePurchasableReceiptPtr FGamebaseEventPurchasableReceipt::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebasePurchasableReceiptPtr PurchasableReceipt = MakeShared<FGamebasePurchasableReceipt, ESPMode::ThreadSafe>();
    PurchasableReceipt->FromJson(JsonString);
    
    return PurchasableReceipt;
}

FGamebaseEventPushMessagePtr FGamebaseEventPushMessage::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventPushMessagePtr PushMessage = MakeShared<FGamebaseEventPushMessage, ESPMode::ThreadSafe>();
    PushMessage->FromJson(JsonString);
    
    return PushMessage;
}

void FGamebaseEventPushMessage::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("body", Body);
    NHN_JSON_SERIALIZE("extras", Extras);
    NHN_JSON_SERIALIZE("id", Id);
    NHN_JSON_SERIALIZE("title", Title);
    END_NHN_VO_SERIALIZER
}

FGamebaseEventPushActionPtr FGamebaseEventPushAction::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventPushActionPtr PushAction = MakeShared<FGamebaseEventPushAction, ESPMode::ThreadSafe>();
    PushAction->FromJson(JsonString);
    
    return PushAction;
}

void FGamebaseEventPushAction::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("actionType", ActionType);
    NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("message", Message);
    NHN_JSON_SERIALIZE("userText", UserText);
    END_NHN_VO_SERIALIZER
}

FGamebaseEventLoggedOutDataPtr FGamebaseEventLoggedOutData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventLoggedOutDataPtr LoggedOutData = MakeShared<FGamebaseEventLoggedOutData, ESPMode::ThreadSafe>();
    LoggedOutData->FromJson(JsonString);
    
    return LoggedOutData;
}

void FGamebaseEventLoggedOutData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("message", message);
    NHN_JSON_SERIALIZE("extras", extras);
    END_NHN_VO_SERIALIZER
}

FGamebaseEventIdPRevokedDataPtr FGamebaseEventIdPRevokedData::From(const FString& JsonString)
{
    if (JsonString.IsEmpty() == true)
    {
        return nullptr;
    }
    
    const FGamebaseEventIdPRevokedDataPtr ObserverData = MakeShared<FGamebaseEventIdPRevokedData, ESPMode::ThreadSafe>();
    ObserverData->FromJson(JsonString);
    
    return ObserverData;
}

void FGamebaseEventIdPRevokedData::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("code", Code);
    NHN_JSON_SERIALIZE("idPType", IdpType);
    NHN_JSON_SERIALIZE_ARRAY("authMappingList", AuthMappingList);
    NHN_JSON_SERIALIZE("extras", Extras);
    END_NHN_VO_SERIALIZER
}
