#include "GamebaseError.h"

#include "NhnJsonSerializeMacros.h"

void FGamebaseError::AddExtra(const FString& Key, const FString& Value)
{
    if (!Extras.IsSet())
    {
        Extras.Emplace();
    }
        
    Extras.GetValue().Add(Key, Value);
}

TOptional<FString> FGamebaseError::FindExtra(const FString& Key) const
{
    if (!Extras.IsSet())
    {
        return {};
    }

    const TMap<FString, FString>& Map = Extras.GetValue();
    const FString* Found = Map.Find(Key);
    
    return Found ? TOptional<FString>(*Found) : TOptional<FString>();
}

void FGamebaseError::ForEachDepth(const FErrorVisitor& Visitor) const
{
    Visitor(*this);
    
    if (Error.IsValid())
    {
        Error->ForEachDepth(Visitor);
    }
}

int32 FGamebaseError::GetDepth() const
{
    int32 Depth = 1;
    
    if (Error.IsValid())
    {
        Depth += Error->GetDepth();
    }
    
    return Depth;
}

void FGamebaseError::Serialize(FJsonSerializerBase& Serializer, const bool bFlatObject)
{
    BEGIN_NHN_VO_SERIALIZER
    NHN_JSON_SERIALIZE("domain", Domain);
    NHN_JSON_SERIALIZE("code", Code);
    NHN_JSON_SERIALIZE("message", Message);
    NHN_JSON_SERIALIZE_OPTIONAL("transactionId", TransactionId);
    NHN_JSON_SERIALIZE_OPTIONAL_MAP("extras", Extras);
    NHN_JSON_SERIALIZE_PTR_OBJECT_THREADSAFE("error", Error, FGamebaseError);
    END_NHN_VO_SERIALIZER
}