using System.IO;
using NHNCloud.Gamebase;
using UnrealBuildTool;

public class Gamebase : ModuleRules
{
    public Gamebase(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
        
        PublicIncludePaths.AddRange(
            new[] {
                ModuleDirectory + "/Public",
                ModuleDirectory + "/Public/Constants",
                ModuleDirectory + "/Public/Interfaces",
                ModuleDirectory + "/Public/Types"
            }
        );
        
        PublicDependencyModuleNames.AddRange(
            new[]
            {
                "Core",
                "NHNShared",
                "Json",
                "NHNShared",
                "NHNJson"
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new[]
            {
                "CoreUObject",
                "Engine"
            }
        );
        
        ExternalDependencies.Add(Path.Combine(Target.ProjectFile.Directory.FullName, "Config", "DefaultEngine.ini"));
        
        GamebaseRuntime.Initialize(this);
    }
}