﻿#pragma once
#include "GamebaseWebBrowserTypes.h"

struct FBrowserContextSettings;
struct FGamebaseWebBrowserWidgetSettings;

class FGamebaseWebBrowserViewModel
    : public TSharedFromThis<FGamebaseWebBrowserViewModel>
{
public:
    using FCloseFunc = TFunction<void()>;
    using FErrorFunc = TFunction<void(int32 /*ErrorType*/, const FString& /*ErrorInfo*/)>;
    using FSchemeFunc = TFunction<void(const FString& /*Url*/)>;
    
    static TSharedRef<FGamebaseWebBrowserViewModel> Create(
        const FString& Url,
        const TSharedRef<FGamebaseWebBrowserWidgetSettings>& BrowserConfiguration,
        const TSharedRef<FGamebaseWebBrowserContextSettings>& BrowserContextSettings,
        const TArray<FString>& SchemeList,
        const FCloseFunc& OnRequestClose,
        const FErrorFunc& OnRedirectURL,
        const FSchemeFunc& OnSchemeEvent,
        bool bConsumeInput);

    virtual ~FGamebaseWebBrowserViewModel() = default;

    virtual FString GetUrl() = 0;
    virtual const TSharedRef<FGamebaseWebBrowserWidgetSettings>& GetBrowserConfiguration() const = 0;
    virtual const TOptional<FBrowserContextSettings> GetBrowserContextSettings() const = 0;
    virtual const TArray<FString> GetSchemeList() const = 0;
    virtual bool ShouldConsumeInput() const = 0;

    virtual void HandleRequestClose(const FString& CloseInfo) = 0;
    virtual void HandleLoadError() = 0;
    virtual bool HandleBrowserUrlChanged(const FText& Url) = 0;
    virtual bool HandleBeforeBrowse(const FString& Url) = 0;
    virtual bool HandleNavigation(const FString& Url) = 0;
};