﻿#pragma once

#include "CoreMinimal.h"

class FSlateStyleSet;

class FGamebaseWebBrowserStyleSet
{
public:
    static void Initialize();
    static void Shutdown();
    static void Reload();

    static ISlateStyle& Get();
    static FName GetStyleSetName();

    static FSlateColor GetSlateColor(const FName PropertyName, const ANSICHAR* Specifier = nullptr);
    
private:
    static TSharedRef<FSlateStyleSet> Create();

private:
    static TSharedPtr<FSlateStyleSet> StyleInstance;
};
