#include "GamebaseWebBrowserStyleSet.h"

#include "GamebaseSystemUtils.h"
#include "SlateBasics.h"
#include "Styling/CoreStyle.h"

#define DEFAULT_FONT(...)                   FCoreStyle::GetDefaultFontStyle(__VA_ARGS__)
#define IMAGE_BRUSH(RelativePath, ...)      FSlateImageBrush(StyleRef->RootToContentDir(RelativePath, TEXT(".png")), __VA_ARGS__)
#define CORE_IMAGE_BRUSH(RelativePath, ...) FSlateImageBrush(StyleRef->RootToCoreContentDir(RelativePath, TEXT(".png")), __VA_ARGS__)

constexpr FColor SuperDark(1, 1, 1, 255);

constexpr FColor SuperDarkListA(2, 2, 2, 255);
constexpr FColor SuperDarkListB(3, 3, 3, 255);

constexpr FColor Dark(4, 4, 4, 255);
constexpr FColor Navy(0, 0, 4, 255);
constexpr FColor DeepRed(6, 0, 0, 255);
constexpr FColor Medium(10, 10, 10, 255);
constexpr FColor Light(14, 14, 14, 255);
constexpr FColor SuperLight(32, 32, 32, 255);
constexpr FColor UltraBright(61, 135, 255, 255);
constexpr FColor Bright(128, 128, 128, 255);
constexpr FColor WhiteBright(255, 255, 255, 255);
constexpr FColor GoldBright(255, 255, 171, 255);
constexpr FColor Disabled(189, 189, 189, 255);
constexpr FColor Shaded(4, 4, 4, 200);
constexpr FColor Pressed(250, 250, 250, 255);
constexpr FColor Hovered(200, 200, 200, 255);

TSharedPtr<FSlateStyleSet> FGamebaseWebBrowserStyleSet::StyleInstance = nullptr;

void FGamebaseWebBrowserStyleSet::Initialize()
{
    if (!StyleInstance.IsValid())
    {
        StyleInstance = Create();
        FSlateStyleRegistry::RegisterSlateStyle(*StyleInstance);
    }
}

void FGamebaseWebBrowserStyleSet::Shutdown()
{
    if (StyleInstance.IsValid())
    {
        FSlateStyleRegistry::UnRegisterSlateStyle(*StyleInstance);
        ensure(StyleInstance.IsUnique());
        StyleInstance.Reset();
    }
}

void FGamebaseWebBrowserStyleSet::Reload()
{
    FSlateApplication::Get().GetRenderer()->ReloadTextureResources();
}

ISlateStyle& FGamebaseWebBrowserStyleSet::Get()
{
    return *StyleInstance;
}

FName FGamebaseWebBrowserStyleSet::GetStyleSetName()
{
    static FName StyleSetName(TEXT("GamebaseWebBrowserStyleSet"));
    return StyleSetName;
}

FSlateColor FGamebaseWebBrowserStyleSet::GetSlateColor(const FName PropertyName, const ANSICHAR* Specifier)
{
    if (PropertyName == FName(TEXT("NormalTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("FocusTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("HoverTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("PressedTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("DisabledTextColor"))) return FSlateColor(FLinearColor(0.0, 0.0, 0.0, 1.0));

    if (PropertyName == FName(TEXT("TabNormalTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("TabFocusTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("TabHoverTextColor"))) return FSlateColor(FLinearColor(1.0, 1.0, 1.0, 1.0));
    if (PropertyName == FName(TEXT("TabPressedTextColor"))) return FSlateColor(FLinearColor(0.0, 0.0, 0.0, 1.0));
    if (PropertyName == FName(TEXT("TabDisabledTextColor"))) return FSlateColor(FLinearColor(0.0, 0.0, 0.0, 1.0));

    return FSlateColor(FLinearColor(0.6, 0.6, 0.6, 1.0));
}

TSharedRef<FSlateStyleSet> FGamebaseWebBrowserStyleSet::Create()
{
    TSharedRef<FSlateStyleSet> StyleRef = MakeShareable(new FSlateStyleSet(GetStyleSetName()));
    
    StyleRef->SetContentRoot(GamebaseSystemUtils::GetContentPath() / TEXT("Slate"));
    StyleRef->SetCoreContentRoot(FPaths::EngineContentDir() / TEXT("Slate"));
    
    StyleRef->Set("CefWebView.Background", new FSlateColorBrush(SuperLight));
    StyleRef->Set("CefWebView.Navigation.Background", new FSlateColorBrush(WhiteBright));

    // Button
    {
        // Note, these sizes are in Slate Units.
        // Slate Units do NOT have to map to pixels.
        const FVector2D Icon64X64(64.0f, 64.0f);
        const FVector2D Icon24X24(24.0f, 24.0f);

        StyleRef->Set("CefWebView.StandardButton", FButtonStyle()
            .SetNormal(FSlateColorBrush(SuperLight))
            .SetHovered(FSlateColorBrush(SuperLight))
            .SetPressed(FSlateColorBrush(Light))
            .SetDisabled(FSlateColorBrush(SuperDark))
            //.SetNormalPadding(FMargin(0.0f, 10.0f, 0.0f, 10.0f))
            //.SetPressedPadding(FMargin(0.0f, 10.0f, 0.0f, 10.0f))
        );
        
        StyleRef->Set("CefWebView.BackButton", FButtonStyle()
            .SetNormal(FSlateColorBrush(FColor::Transparent))
            .SetHovered(FSlateColorBrush(SuperLight))
            .SetPressed(FSlateColorBrush(Light))
            .SetDisabled(FSlateColorBrush(SuperDark))
        );
        
        StyleRef->Set("CefWebView.BackButton.Image", new IMAGE_BRUSH("back-white", Icon64X64));

        StyleRef->Set("CefWebView.CloseButton", FButtonStyle()
            .SetNormal(FSlateColorBrush(SuperLight))
            .SetHovered(FSlateColorBrush(SuperLight))
            .SetPressed(FSlateColorBrush(Light))
            .SetDisabled(FSlateColorBrush(SuperDark))
        );
        
        StyleRef->Set("CefWebView.CloseButton.Image", new IMAGE_BRUSH("close-white", Icon64X64));

        StyleRef->Set("CefWebView.ClosePopupButton.Image", new IMAGE_BRUSH("close-popup", Icon24X24));
    }
    
    // Text
    {
        StyleRef->Set("CefWebView.TitleText", FTextBlockStyle()
            .SetFont(DEFAULT_FONT("Bold", 32))
            .SetColorAndOpacity(FLinearColor::White)
        );
        
        StyleRef->Set("CefWebView.SubTitleText", FTextBlockStyle()
            .SetFont(DEFAULT_FONT("Bold", 16))
            .SetColorAndOpacity(FLinearColor::White)
        );

        StyleRef->Set("CefWebView.Dialog.MessageText", FTextBlockStyle()
            .SetFont(DEFAULT_FONT("Bold", 20))
            .SetColorAndOpacity(FLinearColor::Black)
        );
    }

    return StyleRef;
}

#undef DEFAULT_FONT
#undef IMAGE_BRUSH
#undef CORE_IMAGE_BRUSH