﻿#pragma once

#include "IWebBrowserSchemeHandler.h"

class FGamebaseSchemeHandler final
    : public IWebBrowserSchemeHandler
{
public:
    virtual bool ProcessRequest(const FString& Verb, const FString& Url, const FSimpleDelegate& OnHeadersReady) override
    {
        OnHeadersReady.ExecuteIfBound();
        return true;
    }
    
    virtual void GetResponseHeaders(IHeaders& OutHeaders) override
    {   
        OutHeaders.SetStatusCode(204);
    }
    
    virtual bool ReadResponse(uint8* OutBytes, int32 BytesToRead, int32& BytesRead, const FSimpleDelegate& OnMoreDataReady) override
    {
        BytesRead = 0;
        return false;
    }
    
    virtual void Cancel() override
    {   
    }
};

class FGamebaseSchemeHandlerFactory final
    : public IWebBrowserSchemeHandlerFactory
{
public:
    virtual TUniquePtr<IWebBrowserSchemeHandler> Create(FString Verb, FString Url) override
    {
        return MakeUnique<FGamebaseSchemeHandler>();
    }
};

using FGamebaseSchemeHandlerFactoryPtr = TSharedPtr<FGamebaseSchemeHandlerFactory>;