﻿using System.IO;
using UnrealBuildTool;
using NHNCloud.Gamebase;

public class GamebaseStandaloneWebBrowser : ModuleRules
{
    public GamebaseStandaloneWebBrowser(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
        
        PublicDependencyModuleNames.AddRange(
            new[] {
                "Core",
                "CoreUObject",
                "Gamebase",
                "GamebaseCore",
                "NHNJson"
            }
        );
        
        PrivateDependencyModuleNames.AddRange(
            new[] {
                "WebBrowserWidget",
                "WebBrowser",
                "Slate",
                "SlateCore",
                "UMG",
                "InputCore",
            }
        );
        
        if (!GamebaseRuntime.Instance.IsMacroEnabled(Macro.WITH_GAMEBASE_WEBVIEW_ENGINE_PLUGIN))
        {
            return;
        }
        
        PrivateDependencyModuleNames.AddRange(
            new[] {
                "WebBrowserWidget",
                "WebBrowser",
                "Slate",
                "SlateCore",
                "UMG",
                "InputCore"
            }
        );
                
        if (Target.bUsesSlate)
        {
            RuntimeDependencies.Add(Path.Combine(PluginDirectory, "Content", "Slate", "..."), StagedFileType.UFS);
        }
    }
}