#include "GamebaseStandalonePurchaseEpicGames.h"

#include "GamebaseDebugLogger.h"
#include "IGamebaseIapManager.h"

#include "Constants/GamebaseStoreCode.h"
#include "Types/GamebasePurchaseConfiguration.h"

#if WITH_GAMEBASE_EOS_SHARED
#include "eos_types.h"
#include "GamebaseSharedEOS.h"
#endif

namespace GamebaseSettings
{
    FString GetWindowsSetting(const FString& Key)
    {
        FString Result;
        if (GConfig->GetString(TEXT("/Script/GamebaseEditor.GamebaseWindowsPlatformSettings"), *Key, Result, GEngineIni) == false)
        {
            GAMEBASE_LOG_GLOBAL_WARNING("%s is not found.", *Key);
        }
        
        return Result;
    }
}

namespace GamebasePurchaseEpic
{
    namespace IdPInfo
    {
        const FName GameName(TEXT("GameName"));
        const FName GameOfferId(TEXT("GameOfferId"));
        const FName ApplicationId(TEXT("ApplicationId"));
        const FName ProductId(TEXT("ProductId"));
        const FName SandboxId(TEXT("SandboxId"));
        const FName DeploymentId(TEXT("DeploymentId"));
        const FName ClientCredentialsId(TEXT("ClientCredentialsId"));
        const FName ClientCredentialsSecret(TEXT("ClientCredentialsSecret"));
    }
}

FGamebaseIapConfiguration UGamebaseStandalonePurchaseEpicGames::GetConfiguration(const FGamebasePurchaseConfiguration& Configuration) const
{
    using namespace GamebasePurchaseEpic;

    FGamebaseIapConfiguration IapConfiguration;
    IapConfiguration.Type = GetUniqueKey();
#if WITH_GAMEBASE_EOS_SHARED
    IapConfiguration.LibPath = FPaths::ProjectDir() / TEXT("Binaries") / EOSSDK_RUNTIME_LIBRARY_NAME;
#endif
    IapConfiguration.LogLevel = 3;
    IapConfiguration.LogTarget = 4;
    IapConfiguration.Appkey = Configuration.IapAppkey;
    IapConfiguration.HostUrl = Configuration.ServerUrl;
    
    FGamebaseVariantMap IdpInfoMap;
    IdpInfoMap.Add(IdPInfo::GameName, GamebaseSettings::GetWindowsSetting(TEXT("EosGameName")));
    IdpInfoMap.Add(IdPInfo::GameOfferId, GamebaseSettings::GetWindowsSetting(TEXT("EosGameOfferId")));
    IdpInfoMap.Add(IdPInfo::ApplicationId, GamebaseSettings::GetWindowsSetting(TEXT("EosApplicationId")));
    IdpInfoMap.Add(IdPInfo::ProductId, GamebaseSettings::GetWindowsSetting(TEXT("EosArtifactProductId")));
    IdpInfoMap.Add(IdPInfo::SandboxId, GamebaseSettings::GetWindowsSetting(TEXT("EosArtifactSandboxId")));
    IdpInfoMap.Add(IdPInfo::DeploymentId, GamebaseSettings::GetWindowsSetting(TEXT("EosArtifactDeploymentId")));
    IdpInfoMap.Add(IdPInfo::ClientCredentialsId, GamebaseSettings::GetWindowsSetting(TEXT("EosArtifactClientCredentialsId")));
    IdpInfoMap.Add(IdPInfo::ClientCredentialsSecret, GamebaseSettings::GetWindowsSetting(TEXT("EosArtifactClientCredentialsSecret")));
    IapConfiguration.IdpInfo = IdpInfoMap;

    return IapConfiguration;
}

FString UGamebaseStandalonePurchaseEpicGames::GetUniqueKey() const
{
    return GamebaseStoreCode::EpicGames;
}

void UGamebaseStandalonePurchaseEpicGames::PreInitialize(const FGamebasePurchaseConfiguration& Configuration)
{
#if WITH_GAMEBASE_EOS_SHARED
    EOS_HPlatform PlatformHandle = nullptr;
    
    if (const auto SharedEOS = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GetWorld()->GetGameInstance()))
    {
        PlatformHandle = SharedEOS->GetPlatformHandle();
    }
    
    if (GetIapManager() && PlatformHandle)
    {
        GetIapManager()->SetEOSPlatformHandle(PlatformHandle);
    }
    else
    {
        GAMEBASE_LOG_GLOBAL_WARNING("Unable to set EOS PlatformHandle.");
    }
#endif // WITH_GAMEBASE_EOS_SHARED
}
