#pragma once

#include "CoreMinimal.h"
#include "GamebaseBaseTypes.h"
#include "NhnJsonSerializeMacros.h"

struct FGamebaseError;
struct FGamebasePurchasableConfiguration;

struct FGamebaseIapConfiguration final : FNhnJsonSerializable
{
    FString Type;
    FString LibPath;
    FString LogPath = FPaths::ProjectLogDir();
    int32 LogLevel;
    int32 LogTarget;
    FString HostUrl;
    FString Appkey;
    TOptional<FGamebaseVariantMap> IdpInfo;
    
    BEGIN_NHN_JSON_SERIALIZER
        NHN_JSON_SERIALIZE_STRING("type", Type);
        NHN_JSON_SERIALIZE_STRING("libPath", LibPath);
        NHN_JSON_SERIALIZE_STRING("logPath", LogPath);
        NHN_JSON_SERIALIZE("logLevel", LogLevel);
        NHN_JSON_SERIALIZE("logTarget", LogTarget);
        NHN_JSON_SERIALIZE_STRING("hostUrl", HostUrl);
        NHN_JSON_SERIALIZE_STRING("appKey", Appkey);
        NHN_JSON_SERIALIZE_OPTIONAL_VARIANT_MAP("idpInfo", IdpInfo);
    END_NHN_JSON_SERIALIZER
};

struct FIapPurchaseReceipt
{
    FString GamebaseProductId;
    int64 ItemSeq;
    float Price;
    FString Currency;
    FString PaymentSeq;
    FString PurchaseToken;
    FString MarketItemId;
    FString ProductType;
    FString UserId;
    FString PaymentId;
    FString OriginalPaymentId;
    int64 PurchaseTime;
    int64 ExpiryTime;
    FString StoreCode;
    FString Payload;
    bool bIsPromotion;
    bool bIsTestPurchase;
};

struct FIapPurchasableItem
{
    int64 ItemSeq;
    float Price;
    FString Currency;
    //FString ItemName;
    FString MarketItemId;
    FString ProductType;
    FString LocalizedPrice;
    FString LocalizedTitle;
    FString LocalizedDescription;
    bool bIsActive;
};

struct FGamebasePurchaseAdapterConfiguration
{
    struct FArtifact
    {
        FString ApplicationId;
        FString ProductId;
        FString SandboxId;
        FString DeploymentId;
        FString ClientCredentialsId;
        FString ClientCredentialsSecret;
    };
    
    FString GameName;
    FString GameOfferId;
    FArtifact Artifact;
};

using FIapPurchaseReceiptArray = TArray<FIapPurchaseReceipt>;
using FIapPurchasableItemArray = TArray<FIapPurchasableItem>;

DECLARE_DELEGATE_TwoParams(FIapPurchaseReceiptDelegate, const TOptional<FIapPurchaseReceipt>&, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FIapPurchaseReceiptListDelegate, const TOptional<FIapPurchaseReceiptArray>&, const FGamebaseError*);
DECLARE_DELEGATE_TwoParams(FIapPurchasableItemListDelegate, const TOptional<FIapPurchasableItemArray>&, const FGamebaseError*);

