﻿#pragma once

#include "CoreMinimal.h"
#include "IGamebaseIapManager.h"

class FGpWindowsIapManager final : public IGamebaseIapManager
{
public:
    FGpWindowsIapManager();
    virtual ~FGpWindowsIapManager() override;

    virtual void Initialize(const FGamebaseIapConfiguration& Configuration, const FGamebaseIapCallbackDelegate& Callback) override;
    virtual void SetDebugMode(bool bIsDebugMode) override;
    virtual void SetUserInfo(const FString& GamebaseUserId, const FString& GamebaseAccessToken) override;
    virtual void Login(const FGamebaseIapCallbackDelegate& Callback) override;
    virtual void Logout(const FGamebaseIapCallbackDelegate& Callback) override;
    virtual void Release() override;
    virtual void Update() override;
    virtual void AddListenerEvent() override;
    virtual void RemoveListenerEvent() override;
    
    virtual void RequestItemListOfNotConsumed(bool bAllStores, FGamebaseIapResultFunc&& Callback) override;
    virtual void RequestPurchaseProductId(const FString& MarketItemId, const FString& GamebaseProductId, FGamebaseIapResultFunc&& Callback) override;
    virtual void RequestPurchaseProductIdWithPayload(const FString& MarketItemId, const FString& GamebaseProductId, const FString& Payload, FGamebaseIapResultFunc&& Callback) override;
    virtual void RequestItemListPurchasable(FGamebaseIapResultFunc&& Callback) override;
    virtual void RequestReprocessPurchased(const FString& GamebaseItemListJsonString, const FGamebaseIapCallbackDelegate& Callback) override;

#if WITH_GAMEBASE_EOS_SHARED
    virtual void SetEOSPlatformHandle(EOS_HPlatform PlatformHandle) override;
#endif
    
    void OnCallback(int32 Code, const char* Message);
    
    static void Login(const FGamebaseErrorDelegate& Callback);
    static void LoginWithDevAuthTool(const FString& Host,const FString& CredentialName, const FGamebaseErrorDelegate& Callback);
    static void Logout(const FGamebaseErrorDelegate& Callback);
    static void RequestPurchaseEpicGameOffer(const FString& GameOfferId, const FGamebaseErrorDelegate& Callback);
    static void IapServerConsumeForTest(const FString& PaymentSeq, const FString& AccessToken, const FGamebaseErrorDelegate& Callback);
    
    void Shutdown();
    
private:
    static bool ImportDll();
    static bool ShutdownDll();
    
    static FGamebaseErrorPtr AvailableDll();
    static FGamebaseErrorPtr ProcessingApi();
    static bool IsAvailableDll();
    static bool IsProcessingApi();
};
