#pragma once

#include "NhnJsonSerializable.h"

namespace GpWindowsIapSdk
{
    struct FConfiguration final : FNhnJsonSerializable
    {
        struct FIdpInfo final : FNhnJsonSerializable
        {
            FString ApplicationId;
            FString ProductId;
            FString SandboxId;
            FString DeploymentId;
            FString ClientCredentialsId;
            FString ClientCredentialsSecret;
            FString GameName;
            FString GameOfferId;
            
            BEGIN_NHN_JSON_SERIALIZER
                NHN_JSON_SERIALIZE_STRING("ApplicationId", ApplicationId);
                NHN_JSON_SERIALIZE_STRING("ProductId", ProductId);
                NHN_JSON_SERIALIZE_STRING("SandboxId", SandboxId);
                NHN_JSON_SERIALIZE_STRING("DeploymentId", DeploymentId);
                NHN_JSON_SERIALIZE_STRING("ClientCredentialsId", ClientCredentialsId);
                NHN_JSON_SERIALIZE_STRING("ClientCredentialsSecret", ClientCredentialsSecret);
                NHN_JSON_SERIALIZE_STRING("gameName", GameName);
                NHN_JSON_SERIALIZE_STRING("gameOfferId", GameOfferId);
            END_NHN_JSON_SERIALIZER
        };
        
        FString Type;
        int32 LogLevel;
        int32 LogTarget;
        FString HostUrl;
        FString Appkey;
        FIdpInfo IdpInfo;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE_STRING("type", Type);
            NHN_JSON_SERIALIZE("logLevel", LogLevel);
            NHN_JSON_SERIALIZE("logTarget", LogTarget);
            NHN_JSON_SERIALIZE_STRING("hostUrl", HostUrl);
            NHN_JSON_SERIALIZE_STRING("appKey", Appkey);
            NHN_JSON_SERIALIZE_OBJECT_SERIALIZABLE("idpInfo", IdpInfo);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FPurchasableDefaultData final : FNhnJsonSerializable
    {
        int32 ProductNo;
        FString ProductId;
        float OriginalPrice;
        FString Currency;
        bool bPriceValid;
        FString ProductName;
        FString LocalizedPrice;
        FString LocalizedDescription;
        int32 DecimalPoint;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("marketProductId", ProductId);
            NHN_JSON_SERIALIZE("productNo", ProductNo);
            NHN_JSON_SERIALIZE("originalPrice", OriginalPrice);
            NHN_JSON_SERIALIZE("currency", Currency);
            NHN_JSON_SERIALIZE("decimalPoint", DecimalPoint);
            NHN_JSON_SERIALIZE("priceValid", bPriceValid);
            NHN_JSON_SERIALIZE("productName", ProductName);
            NHN_JSON_SERIALIZE("localizedPrice", LocalizedPrice);
            NHN_JSON_SERIALIZE("localizedDescription", LocalizedDescription);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FPurchaseReceiptData final : FNhnJsonSerializable
    {
        FString Currency;
        FString GamebaseProductId;
        FString MarketItemId;
        FString OriginalPaymentId;
        FString PaymentId;
        FString PaymentSeq;
        float Price;
        FString ProductType;
        int64 PurchaseTime;
        FString PurchaseToken;
        FString UserId;
        FString GamebasePayload;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("currency", Currency);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
            NHN_JSON_SERIALIZE("marketItemId", MarketItemId);
            NHN_JSON_SERIALIZE("originalPaymentId", OriginalPaymentId);
            NHN_JSON_SERIALIZE("paymentId", PaymentId);
            NHN_JSON_SERIALIZE("paymentSeq", PaymentSeq);
            NHN_JSON_SERIALIZE("price", Price);
            NHN_JSON_SERIALIZE("productType", ProductType);
            NHN_JSON_SERIALIZE("purchaseTime", PurchaseTime);
            NHN_JSON_SERIALIZE("purchaseToken", PurchaseToken);
            NHN_JSON_SERIALIZE("userId", UserId);
            NHN_JSON_SERIALIZE("gamebasePayload", GamebasePayload);
        END_NHN_JSON_SERIALIZER
    };
    
    struct FGamebasePayload final : FNhnJsonSerializable
    {
        FString StoreUserId;
        FString GamebaseProductId;
        
        BEGIN_NHN_JSON_SERIALIZER
            NHN_JSON_SERIALIZE("storeUserId", StoreUserId);
            NHN_JSON_SERIALIZE("gamebaseProductId", GamebaseProductId);
        END_NHN_JSON_SERIALIZER
    };
}
