#pragma once

#include "CoreMinimal.h"
#include "GamebaseStandaloneAuthAdapter.h"
#include "GamebaseStandaloneAuthSteam.generated.h"

UCLASS()
class UGamebaseStandaloneAuthSteam final : public UGamebaseStandaloneAuthAdapter
{
    GENERATED_BODY()

public:
    virtual void Initialize(const FGamebaseAuthConfiguration& Configuration) override;
    virtual void Login(const FGamebaseVariantMap& AdditionalInfo, const FLoginCallback& Callback) override;
    virtual void Logout(const FLogoutCallback& Callback) override;
    virtual void Withdraw(const FWithdrawCallback& Callback) override;
    virtual FString GetProviderName() const override;
    virtual FString GetUserID() const override;
    virtual FString GetAccessToken() const override;
    virtual FGamebaseAuthProviderProfilePtr GetProfile() const override;

protected:
    virtual FString GetUniqueKey() const override;

#if WITH_GAMEBASE_STEAMWORKS_SHARED
    TSharedPtr<class FGamebaseSteamWebApiAuthTicketRequest> Event = nullptr;
#endif
};
