﻿#include "GamebaseStandaloneAuthLine.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseAuthProviderCredential.h"

FGamebaseVariantMap UGamebaseStandaloneAuthLine::GetProviderSpecificQueries() const
{
    FGamebaseVariantMap Result;

    if (AuthConfiguration.UserAdditionalInfo.Contains(GamebaseAuthProviderCredential::LineChannelRegion))
    {
        Result.Add(GamebaseAuthMemberWebLoginParameter::SocialNetworkingServiceSubCode, AuthConfiguration.UserAdditionalInfo[GamebaseAuthProviderCredential::LineChannelRegion]);
    }
    
    return Result;
}

FGamebaseVariantMap UGamebaseStandaloneAuthLine::GetProviderSpecificCredential() const
{
    FGamebaseVariantMap Result;

    if (AuthConfiguration.UserAdditionalInfo.Contains(GamebaseAuthProviderCredential::LineChannelRegion))
    {
        Result.Add(GamebaseAuthProviderCredential::SubCode, AuthConfiguration.UserAdditionalInfo[GamebaseAuthProviderCredential::LineChannelRegion]);
    }
    
    return Result;
}

FString UGamebaseStandaloneAuthLine::GetUniqueKey() const
{
    return GamebaseAuthProvider::Line;
}
