#include "GamebaseStandaloneAuthEpicGames.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseAuthProviderCredential.h"
#include "GamebaseErrorCode.h"
#include "GamebaseSharedEOS.h"
#include "IGamebaseEOSAuthHandler.h"

namespace GamebaseStandaloneAuthEpic
{
    const FName Domain { TEXT("GamebaseStandaloneAuthEpic") };
    const FString AuthorizationProtocol { TEXT("epicgames") };
}

void UGamebaseStandaloneAuthEpicGames::Initialize(
    const FGamebaseAuthConfiguration& Configuration)
{
    GameInstance = GetWorld()->GetGameInstance();
}

void UGamebaseStandaloneAuthEpicGames::Login(
    const FGamebaseVariantMap& AdditionalInfo,
    const FLoginCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Login([Callback](const FGamebaseAuthEpicLoginResult& Result)
        {
            if (Result.IsError())
            {
                Callback(FGamebaseAuthCredentialsResult(Result.GetErrorValue()));
                return;
            }
        
            FGamebaseAuthCredentials Credentials;
            Credentials.Add(GamebaseAuthProviderCredential::AccessToken, Result.GetOkValue().AccessToken);

            Callback(FGamebaseAuthCredentialsResult(Credentials));
        });
    }
    else
    {
        Callback(FGamebaseAuthCredentialsResult(
            FGamebaseError(
                GamebaseErrorCode::AUTH_IDP_LOGIN_FAILED,
                TEXT("AuthHandler is not available"),
                GamebaseStandaloneAuthEpic::Domain
            )
        ));
    }
}

void UGamebaseStandaloneAuthEpicGames::Logout(
    const FLogoutCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Logout();
    }

    Callback();
}

void UGamebaseStandaloneAuthEpicGames::Withdraw(
    const FWithdrawCallback& Callback)
{
    if (const auto AuthHandler = UGameInstance::GetSubsystem<UGamebaseSharedEOS>(GameInstance)->GetAuthHandler())
    {
        AuthHandler->Logout();
    }
    
    Callback();
}

FString UGamebaseStandaloneAuthEpicGames::GetProviderName() const
{
    return Super::GetProviderName();
}

FString UGamebaseStandaloneAuthEpicGames::GetUserID() const
{
    return Super::GetUserID();
}

FString UGamebaseStandaloneAuthEpicGames::GetAccessToken() const
{
    return Super::GetAccessToken();
}

FGamebaseAuthProviderProfilePtr UGamebaseStandaloneAuthEpicGames::GetProfile() const
{
    return Super::GetProfile();
}

FString UGamebaseStandaloneAuthEpicGames::GetUniqueKey() const
{
    return GamebaseAuthProvider::EpicGames;
}