#include "GamebaseStandaloneAuthAppleId.h"

#include "GamebaseAuthProvider.h"
#include "GamebaseAuthProviderCredential.h"

namespace GamebaseAuthAppleIdConstants
{
    const FName SubCode("sign_in_with_apple_js");
}

FGamebaseVariantMap UGamebaseStandaloneAuthAppleId::GetProviderSpecificQueries() const
{
    FGamebaseVariantMap Queries;
    Queries.Add(GamebaseAuthMemberWebLoginParameter::SocialNetworkingServiceSubCode, GamebaseAuthAppleIdConstants::SubCode);
    
    return Queries;
}

FGamebaseVariantMap UGamebaseStandaloneAuthAppleId::GetProviderSpecificCredential() const
{
    FGamebaseVariantMap Credentials;
    Credentials.Add(GamebaseAuthProviderCredential::SubCode, GamebaseAuthAppleIdConstants::SubCode.ToString());
    
    return Credentials;
}

FString UGamebaseStandaloneAuthAppleId::GetUniqueKey() const
{
    return GamebaseAuthProvider::AppleId;
}
